//############################################################
//
//	ControlDlg.cpp : SpeedDome Control Dialog
//
//	OnVideoIn()
//	OnSetCursor()
//	OnMouseMove()
//	OnCreate()
//	OnClose()
//	OnTimer()
//	OnInitialDialog()
//############################################################
#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "SpeedDomeDoc.h"
#include "SpeedDomeView.h"
#include "vfw.h"
#include "mmsystem.h"
#include "misc.h"
#include "MainFrm.h"
#include "windef.h"
#include "comm.h"
#include "Slider.h"
#include "define.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CControlDlg

IMPLEMENT_DYNCREATE(CControlDlg, CDialog)

CControlDlg::CControlDlg()
	: CDialog(CControlDlg::IDD)
{
	//{{AFX_DATA_INIT(CControlDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
hPreBitmap=NULL;
RadarEntry=0;
VideoOn=0;
Flag_PresetPropertySheet=0;
Flag_AF=0;
}

CControlDlg::~CControlDlg()
{

UnlockResource(hSound1);	FreeResource(hSound1);
UnlockResource(hSound2);	FreeResource(hSound2);

}

void CControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CControlDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CControlDlg, CDialog)
	//{{AFX_MSG_MAP(CControlDlg)
	ON_WM_SETCURSOR()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_WM_CTLCOLOR()
	//}}AFX_MSG_MAP
	ON_COMMAND(IDM_O_VIDEOFORMAT,OnMessageBox)
	//----- Joystick function ---------------------------------
	ON_MESSAGE(MM_JOY1BUTTONDOWN,S_JoyButtonDown)
	ON_MESSAGE(MM_JOY1BUTTONUP,S_JoyButtonUp)
	ON_MESSAGE(MM_JOY1MOVE,S_JoyMove)
	//-------- Key --------------------------------------------
	/*
	ON_COMMAND(ID_KEY_M,S_COM_Manual)
	ON_COMMAND(ID_KEY_LEFT,S_COM_Left )
	ON_COMMAND(ID_KEY_RIGHT,S_COM_Right )
	ON_COMMAND(ID_KEY_UP,S_COM_Up )
	ON_COMMAND(ID_KEY_DOWN,S_COM_Down )
	ON_COMMAND(ID_KEY_PGUP,S_COM_PanStop )
	ON_COMMAND(ID_KEY_PGDN,S_COM_TiltStop )
	ON_COMMAND(ID_KEY_C,S_COM_Cruise)
	*/
	//---------------------------------------------------------
	
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CControlDlg diagnostics

#ifdef _DEBUG
void CControlDlg::AssertValid() const
{
	CDialog::AssertValid();
}

void CControlDlg::Dump(CDumpContext& dc) const
{
	CDialog::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CControlDlg message handlers


BOOL CControlDlg::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	// TODO: Add your message handler code here and/or call default

	return CDialog::OnSetCursor(pWnd, nHitTest, message);
}

//#################################################################
//
// OnMouseMove
//
//#################################################################
void CControlDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	
// TODO: Add your message handler code here and/or call default
HWND			hWnd_Child,hWnd_Capture ;
CPoint			Y_CPoint;
POINT			Y_Point;
RECT			Rect;

::GetWindowRect(m_hWnd,&Rect);
Y_CPoint=point;
ClientToScreen(&Y_CPoint);
	Y_Point.x=Y_CPoint.x;
	Y_Point.y=Y_CPoint.y;

y_hWnd_PanSpeed=::GetDlgItem(m_hWnd,IDC_SLIDER_PAN_SPEED);
y_hWnd_TiltSpeed=::GetDlgItem(m_hWnd,IDC_SLIDER_TILT_SPEED);
y_hWnd_ZoomSpeed=::GetDlgItem(m_hWnd,IDC_SLIDER_ZOOM_SPEED);
y_hWnd_FocusSpeed=::GetDlgItem(m_hWnd,IDC_SLIDER_FOCUS_SPEED);

hWnd_Child=::WindowFromPoint(Y_Point);
	
	//------ Judge cursor . if cursor in dialog get capture.-------
	if( (Y_CPoint.x>Rect.left) && (Y_CPoint.x<Rect.right))
		{
		if( (Y_CPoint.y>Rect.top) && (Y_CPoint.y<Rect.bottom))
			{
			hWnd_Capture=::GetCapture();
			if( (hWnd_Child!=y_hWnd_PanSpeed)&&
				(hWnd_Child!=y_hWnd_TiltSpeed)&&
				(hWnd_Child!=y_hWnd_ZoomSpeed)&&
				(hWnd_Child!=y_hWnd_FocusSpeed)	)//--- Don't capture slider bar
				{
				if (hWnd_Capture != m_hWnd )		//-- Set capture if mouse in Dialog
					::SetCapture(m_hWnd);
				if ( m_hWnd != hWnd_Child )			//-- Change cursor if mouse in control
					SetCursor( LoadCursor(AfxGetInstanceHandle(),"POINTER") );
				else								//-- Mouse in Dialog but not control
					{
					SetCursor(LoadCursor(NULL,IDC_ARROW) );
					//------- If LButton of mouse is pressed then deal with MOVE command
					if ( (nFlags & MK_LBUTTON) == MK_LBUTTON)
						{
						int		Y_left=0,Y_top=0;
						Y_left=Rect.left-(G_CPoint.x-point.x);
						Y_top=Rect.top-(G_CPoint.y-point.y);

						MoveWindow(	Y_left,Y_top,
									Rect.right-Rect.left,Rect.bottom-Rect.top,TRUE);
						}
					//--------------
					}
				}
			else
				::ReleaseCapture();
			}
		else
			{
			hWnd_Capture=::GetCapture();
			if (hWnd_Capture == m_hWnd )
				::ReleaseCapture();
			SetCursor(LoadCursor(NULL,IDC_ARROW) );
			}
		}
	else
		{
		hWnd_Capture=::GetCapture();
		if (hWnd_Capture == m_hWnd )
			::ReleaseCapture();
		SetCursor(LoadCursor(NULL,IDC_ARROW) );
		}
//----------------------------------------------------------

	CDialog::OnMouseMove(nFlags, point);
}

//#############################################################
//
//	OnCreate()
//
//#############################################################

int CControlDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	if ( !SetTimer(2,3000,NULL) )
		{
		MessageBox("Error : SetTimer failed !");
		return -1;
		}
	
	return 0;
}

void CControlDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	KillTimer(2);
	
	CDialog::OnClose();
}

//################################################################
//
//	OnTimer()
//
//################################################################
void CControlDlg::OnTimer(UINT nIDEvent) 
{
// TODO: Add your message handler code here and/or call default

char			Para[5];
float			PanDeg=0,TiltDeg=0;
unsigned short 	Temp;
int				Flag=0;

if( nIDEvent==2 )
	{
	//------------- Request Attitude ------------------------
	if ( ( (DomeEnable==1)&&(Flag_Polling==1) )&&(Count>=5) )	//-- If dome is disconnect then disable
		{
		
		Flag=CComm::RequestAttitude(Para);
		if (Flag==0)
			Count=0;

		Para[1]=Para[1]&'\x7f';	Para[3]=Para[3]&'\x7f';
		//--- Pan Degree --------------------------
		Temp=S_WORD(Para[0],Para[1]);
		if(G_DomeType=='\x0')
			PanDeg=(float)(Temp*360.0/768.0);
		else if (G_DomeType=='\x1')
			PanDeg=(float)(Temp*360.0/1600.0);
		else 
			PanDeg=(float)(Temp*360.0/1600.0);

		//--- Tile Degree --------------------------
		Temp=S_WORD(Para[2],Para[3]);		
		if(G_DomeType=='\x0')
			TiltDeg=(float)(Temp*90.0/240.0);
		else if (G_DomeType=='\x1')
			TiltDeg=(float)(Temp*90.0/240.0);
		else 
			TiltDeg=(float)(Temp*90.0/500.0);
		RadarDraw(1,0,PanDeg,TiltDeg);		//-- Start ,counter direction
		
		//-------------------------------------------

		//--- Status
		if ( (Flag==1)&&(PreFlag==0) )
			{
			//hBitmapTimerOnLine=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_STATUS_CIRCLED) );
			SendDlgItemMessage(IDC_COMM_STATUS,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmapTimerOnLine );
			PreFlag=1;
			}
		else
			{
			if( (Flag==0)&&(PreFlag==1) )
				{
				//hBitmapTimerOffLine=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_STATUS_CIRCLEU) );
				SendDlgItemMessage(IDC_COMM_STATUS,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)hBitmapTimerOffLine );
				PreFlag=0;
				}
			}
		//--- Status
		}
	else
		{
		if (RadarEntry==0)
			{
			RadarDraw(1,0,0,0);
			RadarEntry=1;
			}
		if (Count<5)
			Count++;
		}
	}

//-------------------------------------------------------
CDialog::OnTimer(nIDEvent);
}

//###############################################################
//
//	OnInitDialog()
//
//###############################################################
BOOL CControlDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	//-----------------------------------------------------------
	HINSTANCE		hInstance;

	hInstance=AfxGetInstanceHandle();
	hSound1 = LoadResource(hInstance, FindResource(hInstance, "SOUND1", "WAVE"));
	hSound2 = LoadResource(hInstance, FindResource(hInstance, "SOUND2", "WAVE"));
	lpSound1 =(char *) LockResource(hSound1);
	lpSound2 =(char *) LockResource(hSound2);
	//---------- Initial brush object ----------------------------
	m_brush.CreateStockObject(NULL_BRUSH);
	//------------------------------------------------------------
	L_pMainWnd=AfxGetMainWnd();
	//----------- Slider -----------------------------------------
	CSliderCtrl*	pSlider_PanSpeed;
	CSliderCtrl*	pSlider_TiltSpeed;
	CSliderCtrl*	pSlider_ZoomSpeed;
	CSliderCtrl*	pSlider_FocusSpeed;

	pSlider_PanSpeed=(CSliderCtrl* )					GetDlgItem(IDC_SLIDER_PAN_SPEED);
	pSlider_PanSpeed->SetRange(0,14);					pSlider_PanSpeed->SetPos(10);

	pSlider_TiltSpeed=(CSliderCtrl* )					GetDlgItem(IDC_SLIDER_TILT_SPEED);
	pSlider_TiltSpeed->SetRange(0,14);					pSlider_TiltSpeed->SetPos(10);

	pSlider_ZoomSpeed=(CSliderCtrl* )					GetDlgItem(IDC_SLIDER_ZOOM_SPEED);
	pSlider_ZoomSpeed->SetRange(0,3);					pSlider_ZoomSpeed->SetPos(3);

	pSlider_FocusSpeed=(CSliderCtrl* )					GetDlgItem(IDC_SLIDER_FOCUS_SPEED);
	pSlider_FocusSpeed->SetRange(0,3);					pSlider_FocusSpeed->SetPos(3);

	OldSlider[0]=(WNDPROC)SetWindowLong( GetDlgItem(IDC_SLIDER_PAN_SPEED)->m_hWnd,
										 GWL_WNDPROC,(LONG)S_NewSlider );
	OldSlider[1]=(WNDPROC)SetWindowLong( GetDlgItem(IDC_SLIDER_TILT_SPEED)->m_hWnd,
										 GWL_WNDPROC,(LONG)S_NewSlider );
	OldSlider[2]=(WNDPROC)SetWindowLong( GetDlgItem(IDC_SLIDER_ZOOM_SPEED)->m_hWnd,
										 GWL_WNDPROC,(LONG)S_NewSlider );
	OldSlider[3]=(WNDPROC)SetWindowLong( GetDlgItem(IDC_SLIDER_FOCUS_SPEED)->m_hWnd,
										 GWL_WNDPROC,(LONG)S_NewSlider );
	VERIFY(m_BmpSliderChannel.LoadBitmap(IDB_SLIDER_CHANNEL) );
	VERIFY(m_BmpSliderThumb.LoadBitmap(IDB_SLIDER_THUMB) );
	//----------- Com Port pop-up Menu ---------------------------
	VERIFY(ComPort_menu.LoadMenu(IDR_MENU_COMPORT));
	ASSERT(ComPort_Popup != NULL);
	//----------- Preset Pop-up Menu -----------------------------
	VERIFY(PT_menu.LoadMenu(IDR_MENU_PRESET));
	PT_Popup = PT_menu.GetSubMenu(0);
	G_PT_Popup=PT_Popup;
	ASSERT(PT_Popup != NULL);
	//----------- Sequence Pop-up Menu ---------------------------
	VERIFY(SQ_menu.LoadMenu(IDR_MENU_SEQUENCE));
	ASSERT(SQ_Popup != NULL);
	//----------- Cruise Pop-up Menu -----------------------------
	VERIFY(Cruise_menu.LoadMenu(IDR_MENU_CRUISE));
	ASSERT(Cruise_Popup != NULL);
	//----------- On-Line Timer Bitmap ---------------------------
	hBitmapTimerOnLine=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_STATUS_CIRCLED) );
	hBitmapTimerOffLine=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_STATUS_CIRCLEU) );
	//----------- Radar bitmap -----------------------------------
	VERIFY(m_radBmap.LoadBitmap(IDB_RADAR));
	//----------- LED	bitmap -----------------------------------
	VERIFY(m_LEDBmap.LoadBitmap(IDB_DOMEID_LED));
	//----------- Pad bitmap -------------------------------------
	hBitmapPAD=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_PAD) );  
	hBitmapPAD_STOP=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_PAD_STOP) );
	hBitmapPAD_LEFT=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_PAD_LEFT) );
	hBitmapPAD_UP=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_PAD_UP) );
	hBitmapPAD_RIGHT=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_PAD_RIGHT) );
	hBitmapPAD_DOWN=::LoadBitmap(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDB_PAD_DOWN) );
	//----------- Animation --------------------------------------
	Animate_Panel=(CAnimateCtrl *) GetDlgItem(IDC_ANIMATE_PANEL);
	Animate_Panel->Open("Panel_Corp.avi");
	//Animate_Panel->Open(IDR_AVI_PANEL);
	Animate_Panel->Play(0,0xffff,-1);
	//----------- Ensure joystick exist ----------------------
	/*
	if ( joySetCapture(m_hWnd,JOYSTICKID1,0,FALSE) )
		{
		MessageBox("Couldn't capture the joystick",NULL,
					MB_OK|MB_ICONEXCLAMATION);
		}
	*/
	//--------------------------------------------------------
	PreFlag=0;
	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//################################################################
//	OnMessageBox()
//################################################################
void CControlDlg::OnMessageBox() 
{
AfxMessageBox("Test");
}

//################################################################
//	OnDestroy()
//################################################################
void CControlDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	CloseHandle(hcom);

	DeleteObject(hBitmap);
	DeleteObject(hBitmapTimerOnLine);
	DeleteObject(hBitmapTimerOffLine);
	DeleteObject(hBitmapPAD);
	DeleteObject(hBitmapPAD_STOP);
	DeleteObject(hBitmapPAD_LEFT);
	DeleteObject(hBitmapPAD_UP);
	DeleteObject(hBitmapPAD_RIGHT);
	DeleteObject(hBitmapPAD_DOWN);

}

HBRUSH CControlDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	return hbr;
	
	// TODO: Change any attributes of the DC here
	/*
	pDC->SetBkMode(TRANSPARENT);
	return (HBRUSH) m_brush;
	*/
	// TODO: Return a different brush if the default is not desired
}
